/*:
 * @target MZ
 * @plugindesc メニュー画面のステータス画面でHPとMPを非表示にします。
 * @author YourName
 *
 * @help
 * このプラグインは、RPGツクールMZのメニュー画面（ステータス画面）で
 * HPとMPの表示（ゲージと数値）を非表示にします。
 * 名前、顔グラフィック、装備リストなどは表示されたままです。
 *
 * 使用方法:
 * 1. プラグインを「js/plugins/」フォルダに保存。
 * 2. プラグイン管理で有効化。
 * 3. 特別な設定は不要です。
 *
 * 注意:
 * - 他のステータス画面を変更するプラグインとの競合に注意してください。
 * - プラグインリストの上位に配置することを推奨します。
 * - バックアップを取ってから使用してください。
 */

(() => {
  "use strict";

  // Window_MenuStatusのdrawActorSimpleStatusをオーバーライド
  const _Window_MenuStatus_drawActorSimpleStatus = Window_MenuStatus.prototype.drawActorSimpleStatus;
  Window_MenuStatus.prototype.drawActorSimpleStatus = function(actor, x, y, width) {
    // デバッグ用ログ（コンソールで確認可能）
    console.log("Drawing actor status for: " + actor.name());
    
    const lineHeight = this.lineHeight();
    const x2 = x + 180;
    const width2 = Math.min(200, width - 180 - this.padding());
    
    // 名前、顔グラフィック、クラスのみを描画
    this.drawActorFace(actor, x, y, Window_Base._faceWidth, Window_Base._faceHeight);
    this.drawActorName(actor, x, y + lineHeight * 1);
    this.drawActorClass(actor, x2, y + lineHeight * 1);
    // HPとMPの描画は意図的にスキップ
  };

  // 念のため、HPとMPのゲージ描画関数を空にする
  Window_MenuStatus.prototype.drawActorHp = function(actor, x, y, width) {
    // 何もしない
  };

  Window_MenuStatus.prototype.drawActorMp = function(actor, x, y, width) {
    // 何もしない
  };

})();